﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Accounts
{
    public class UserDetails : BaseComponent
    {
        public UserDetails(Gemini.Core.WebApplication.Interface.IWebPageComponentParam WebPageComponentParam) : base(WebPageComponentParam) { }

        public override bool Save()
        {
            if (WebPageEngine.IsUserAuthorized)
            {
                int? _editMode = Environment.GetRequestParamInt("editmode");
                if (_editMode == 1)
                {
                    BL.BO.Instructor _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                    if (_instructor != null)
                    {
                        _instructor.Title = Environment.GetRequestParamString("Instructor_Title");
                        _instructor.Forename = Environment.GetRequestParamString("Instructor_Forename");
                        _instructor.Surename = Environment.GetRequestParamString("Instructor_Surename");
                        _instructor.Tel = Environment.GetRequestParamString("Instructor_Tel");
                        _instructor.Email = Environment.GetRequestParamString("Instructor_Email");

                        string _password = Environment.GetRequestParamString("Instructor_Password");
                        string _passwordRe = Environment.GetRequestParamString("Instructor_PasswordRe");
                        if (!string.IsNullOrEmpty(_password))
                        {
                            if (_password != _passwordRe)
                            {
                                MethodResult.Add("Hasło nie zostało poprawnie powtórzone.", false);
                                return false;
                            }
                            _instructor.TmpPassword = _password;
                        }


                        if (string.IsNullOrEmpty(_instructor.Forename))
                        {
                            MethodResult.Add("Pole 'Imie' nie może być puste.", false);
                        }

                        if (string.IsNullOrEmpty(_instructor.Surename))
                        {
                            MethodResult.Add("Pole 'Nazwisko' nie może być puste.", false);
                        }

                        if (string.IsNullOrEmpty(_instructor.Email))
                        {
                            MethodResult.Add("Pole 'Email' nie może być puste.", false);
                        }


                        if (MethodResult.Success)
                        {
                            MethodResult.Add(BLELearning.Instructor.Save(_instructor));
                        }

                    }
                    else
                    {
                        BL.BO.Student _student = BLELearning.Student.RestoreByUser(Environment.User);
                        if (_student != null)
                        {
                            string _password = Environment.GetRequestParamString("Student_Password");
                            string _passwordRe = Environment.GetRequestParamString("Student_PasswordRe");
                            _student.Email = Environment.GetRequestParamString("Student_Email");
                            _student.Forename = Environment.GetRequestParamString("Student_Forename");
                            _student.Surename = Environment.GetRequestParamString("Student_Surename");
                            if (!string.IsNullOrEmpty(_password))
                            {
                                if (_password != _passwordRe)
                                {
                                    MethodResult.Add("Hasło nie zostało poprawnie powtórzone.", false);
                                    return false;
                                }
                                _student.TmpPassword = _password;
                            }


                            if (string.IsNullOrEmpty(_student.Forename))
                            {
                                MethodResult.Add("Pole 'Imie' nie może być puste.", false);
                            }

                            if (string.IsNullOrEmpty(_student.Surename))
                            {
                                MethodResult.Add("Pole 'Nazwisko' nie może być puste.", false);
                            }

                            if (string.IsNullOrEmpty(_student.Email))
                            {
                                MethodResult.Add("Pole 'Email' nie może być puste.", false);
                            }

                            if (MethodResult.Success)
                            {
                                MethodResult.Add(BLELearning.Student.Save(_student));
                            }
                        }
                    }
                }
            }
            return true;
        }

        public override void Load()
        {
            #region Config
            XML.Element.Start("Config");
            XML.Element.Attribute("IUA", WebPageEngine.IsUserAuthorized ? "1" : "0");
            XML.Element.End();
            #endregion

            if (WebPageEngine.IsUserAuthorized)
            {
                AppendGroupToXML();

                BL.BO.Student _student = BLELearning.Student.RestoreByUser(Environment.User);
                if (_student != null)
                {
                    AppendUserToXML(true);
                    AppendToXML(_student);
                    AppendToXML(BLELearning.StudentDoc.Restore(_student));
                    BL.BO.Class _class = BLELearning.Class.Restore(_student);
                    if (_class != null)
                    {
                        AppendToXML(_class);

                        BL.BO.School _school = BLELearning.School.Restore(_class.SchoolID);
                        AppendToXML(_school);

                        BL.BO.Instructor _instructor = BLELearning.Instructor.Restore(_class.InstructorID);
                        AppendToXML(_instructor);
                    }
                }
                else
                {
                    BL.BO.Instructor _instructor = BLELearning.Instructor.RestoreByUser(Environment.User);
                    if (_instructor != null)
                    {
                        AppendUserToXML(false);
                        AppendToXML(_instructor);

                        BL.BO.School _school = BLELearning.School.Restore(_instructor.SchoolID);
                        AppendToXML(_school);
                    }
                }
            }
        }
    }
}